package servercore.statics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class StaticsMeothds {

    /**
     * システム日付をHTTP形式の日付書式に変換
     * @param currentTime
     * @return HTTP形式の時刻
     */
	public static String editHttpDate(long milliSecound) {
		// TODO これができるのは日本だけでは？
		milliSecound = milliSecound - TimeZone.getDefault().getRawOffset();
        SimpleDateFormat sdf;
        sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'",
        		Locale.JAPAN);
        String editedDate = sdf.format(new Date(milliSecound));
        return editedDate;
	}

    /**
     * システム日付をログ用に書式編集する
     */
    public static String editTimeForLog(long milliSecound) {
        SimpleDateFormat sdf;
        sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
        String editedDate = sdf.format(new Date(milliSecound));
        return editedDate;
    }
}
